\version "2.18.0"
\language "deutsch"

\paper {
  system-system-spacing = #'((basic-distance . 16))
  markup-system-spacing = #'((basic-distance . 16))
  left-margin = 1.5\cm
  line-width = 19.4\cm
  print-page-number = false
  top-margin = 10\mm
  %ragged-last-bottom=##f
  system-count = #3
}

% diacritice: ă â î ş ţ Ţ Ş Ă Î

\header {
  title = "Pe Domnul lăudaţi-L"
  subtitle = " "
  %subsubtitle = "Op. 19"
  %poet = ""
  %composer = \markup \center-column { "10.01.14" }
  %arranger = "io"
  meter = "nu prea încet"
  tagline=""
}

global = {
  \key g \major
  \autoBeamOff
  %\cadenzaOn
  \time 6/8
  \partial 8
  \set Staff.midiInstrument = "clarinet"
}

womenWordsOne = \lyricmode {
  \set stanza = "1."
  Pe Dom -- nul lă -- u -- da -- ţi-L
  în ce -- ru -- ri -- le 
  \set ignoreMelismata =##t
  sfin -- te!
  \set ignoreMelismata =##f
  Voi, cei din î -- năl -- ţi -- me, 
  slă -- vi -- ţi-L toţi fier --
  \set ignoreMelismata =##t
  bin -- \skip 8
  \set ignoreMelismata =##f
  te;
  voi, cei din î -- năl -- ţi -- me, 
  slă -- vi -- ţi-L toţi fier -- 
  \set ignoreMelismata =##t
  bin -- te!
  \set ignoreMelismata =##f
}

womenWordsTwo = \lyricmode {
  \set stanza = "2."
  Pe Dom -- nul lă -- u -- da -- ţi-L
  tu. soa -- re şi tu. 
  \set ignoreMelismata = ##t
  lu -- nă!
  \set ignoreMelismata = ##f
  Voi,  ste -- le lu -- mi -- noa -- se
  slă -- vi -- ţi-L îm -- pre -- 
  \set ignoreMelismata =##t
  u -- \skip 8
  \set ignoreMelismata =##f
  nă;
  voi,  ste -- le lu -- mi -- noa -- se
  slă -- vi -- ţi-L îm -- pre -- 
  \set ignoreMelismata =##t
  u -- nă.  
  \set ignoreMelismata =##f
}

womenWordsThree = \lyricmode {
  \set stanza = "3."
  A -- du -- ce -- ţi-I Lui sla -- vă,
  gră -- ind în -- tr-un cu -- vânt. __
  Pe Dom -- nul lă -- u -- da -- ţi-L,
  și nu -- me -- le Lui sfânt; __
  pe Dom -- nul lă -- u -- da -- ţi-L,
  și nu -- me -- le Lui sfânt. __ 
}

womenWordsFour = \lyricmode {
  \set stanza = "4."
  Pe Dom -- nul lă -- u -- da -- ţi-L
  toţi în -- ge -- rii la fel, __
  oş -- ti -- ri -- le Lui toa -- te
  să-L la -- u -- de pe El; __
  oş -- ti -- ri -- le Lui toa -- te
  să-L la -- u -- de pe El. __
}

womenWordsFive = \lyricmode {
  \set stanza = "5."
  În veci slă -- viţi pe Dom -- nul
  și nu -- me -- le Lui sfânt, __
  că prea -- mă -- rit e-n ce -- ruri
  pre -- cum şi pe pă -- mânt; __
  că prea -- mă -- rit e-n ce -- ruri
  pre -- cum şi pe pă -- mânt. __
}

tenWords = \lyricmode {
  \skip 1 \skip 1 \skip 1  \skip 1 \skip 1 \skip 1 \skip 1 \skip 1
  \skip 1 \skip 1 \skip 1  \skip 1 \skip 1 \skip 1 \skip 1 \skip 1
  \skip 1 \skip 1 \skip 1  \skip 1 \skip 1 \skip 1 \skip 1 \skip 1
  \skip 1 \skip 1
  
}

basWordsOne = \lyricmode {
  \set stanza = "1."
    
}

basWordsTwo = \lyricmode {
  \set stanza = "2."
  
}

basWordsThree = \lyricmode {
  \set stanza = "3."
  
}

basWordsFour = \lyricmode {
  \set stanza = "4."
  
}

sopMusic = \relative c' {
  d8
  g4 g8 g([ fis]) g a4( fis8) d4 
  d8 a'4 a8 g4 h8 
  \slurDashed
  g4.( g4)
  \slurSolid
  g8
  c4 c8 c([ h]) a h4( a8) g4
  h8 a4 h8 c([ h]) a 
  g4( 
  \slurDashed
  a8 () h4)
  \slurSolid
  g8 c4 c8 c([ h]) a h4( a8) g4
  h8 a4 h8 c([ h]) a 
  \slurDashed
  g4.( g4)
  \slurSolid
  \bar "|."
}

altMusic = \relative c' {
  d8 g4 g8 g([ fis]) e fis4( fis8) d4
  d8 fis4 fis8 g4 g8 
  \slurDashed
  g4.( g4)
  \slurSolid
  %g8 a4 a8 a([g]) fis e4( fis8) g4
  %g8 c4 c8 c([ h]) a h4( a8) g4
  r8 r1*6/8 r1*5/8
  g8 a4 g8 a([ g]) a 
  g4( 
  \slurDashed
  fis8() g4)
  \slurSolid
  g8 a4 a8 a([g]) fis g4( fis8) g4
  h8 a4 h8 a([ g]) fis 
  \slurDashed
  g4.( g4)
  \slurSolid  
}

tenorMusic = \relative c {
  d8 h'4 h8 h([ a]) g a4( a8) a4
  a8 a4 a8 h4 h8 
  \slurDashed
  h4.( h4)
  \slurSolid
  d,8\rest d1*6/8\rest d1*6/8\rest d1*6/8\rest d1*5/8\rest
  %h8 a4 a8 a([g]) fis g4( fis8) e4
  g8 c4 c8 e([ d]) c h4( c8) d4 
  %g8 fis4 fis8 fis([ g]) a8 h4( c8) d4
  d8 c4 h8 a([ g]) a 
  \slurDashed
  h4.( h4)
  \slurSolid
}

bassMusic =  \relative c {
  d8 d4 d8 d([ d]) d d4( e8) fis4
  %d8 g4 g8 fis4 fis8 e4. d4  
  fis8 d8([ h]) a8 g4 g8 %g4. g4
  g8([ a 
  \slurDashed
   h]() 
  \slurSolid
  c()[ d])
  %d8 c4 c8 d4 d8 g4. g4
  %d'8 fis4 fis8 fis4 fis8 c4( c8) c4 
  %r8 r1*6/8 r1*6/8 r1*6/8 r1*5/8
  d8\rest d1*6/8\rest d1*6/8\rest d1*6/8\rest d1*5/8\rest
  r8 r1*6/8 r1*5/8
  %g8 fis4 e8 d([ e]) fis g4. g4
  g8 fis4 fis8 e4 e8 
  \slurDashed
  d4.( d4)
  \slurSolid
}

myScore = \new Score <<
  \new ChoirStaff <<
    \new Staff = "staff" <<
     \new Voice { \voiceOne \global \sopMusic }
     %\new Lyrics \with { alignAboveContext = "staff" } { \sopWords }
     \addlyrics { \womenWordsOne }
     \addlyrics { \womenWordsTwo }
     \addlyrics { \womenWordsThree }
     \addlyrics { \womenWordsFour }
     \addlyrics { \womenWordsFive }
     \new Voice { \voiceTwo \global \altMusic }   
     %\addlyrics { \womenWordsFour }
    >>
    
    \new Staff <<
      \clef bass
      %\new Voice { \global \bassMusic }
      %\new Voice { \global \tenorMusic }
      %\new Lyrics \with { alignAboveContext = "staff" } { \tenorWords }
      \new Voice { \voiceOne \global \tenorMusic }
      %\addlyrics { \tenWords }
      \new Voice { \voiceTwo \global \bassMusic }
      %\new Voice { \global \bassMusic }
      %\addlyrics { \basWordsOne }
      %\addlyrics { \basWordsTwo }
      %\addlyrics { \basWordsThree }  
      %\addlyrics { \basWordsFour } 
    >>
  >>
>>

\score {
  \myScore
  \layout { }
}

midiOutput = \midi {
  \tempo 4 = 37
  \context { \Voice \remove "Dynamic_performer" }
}

\score {
  \myScore
  \midi { \midiOutput }
}

\score {
  \new Voice { \global \sopMusic }
  \midi { \midiOutput }
}

\score {
  \new Voice { \global \altMusic }
  \midi { \midiOutput }
}

\score {
  \new Voice { \global \tenorMusic }
  \midi { \midiOutput }
}

\score {
  \new Voice { \global \bassMusic }
  \midi { \midiOutput }
}